<?php
    // Settings:
    $password = "123";

    ///////////////////////////////////////////////////////////////////////////

    $blacklist_filename = "blacklist.json";
    $success_message = "OK";

    $url_param_operation = "operation";
    $url_param_data = "data";
    $url_param_pass = "pass";

    $operation = $_POST[$url_param_operation] ?? "";
    $param_data = $_POST[$url_param_data] ?? "";
    $url_pass = $_GET[$url_param_pass] ?? "";

    if ($url_pass != $password) {
        if ($operation != "")
            die("Wrong password");    

        echo "<style>*{font-family:sans-serif;text-align:center}form{margin-top:40px}</style><form action='blacklist-interface.php' method='GET'><h1>Enter password</h1><input name='$url_param_pass'><input type='submit' value='Login'></form>";
        if ($url_pass != "")
            echo "<h3>Wrong password</h3>";
        die();
    }
    

    if ($operation && !$param_data)
        die("No param data provided.");

    switch ($operation) {
        case "update":
            (file_put_contents($blacklist_filename, $param_data) !== false) or die($error_message . "Couldn't write to database.");
            die($success_message);
            break;
    }

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js" integrity="sha384-oBqDVmMz9ATKxIep9tiCxS/Z9fNfEXiDAYTujMAeBAsjFuCZSmKbSSUnQlmh/jp3" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js" integrity="sha384-mQ93GR66B00ZXjt0YO5KlohRA5SY2XofN4zfuZxLkoj1gXtW8ANNCe9d5Y3eG5eD" crossorigin="anonymous"></script>
    <style>
        :root {
            --color: #f39c12;
        }

        * {
            box-sizing: border-box;
            margin: 0px;
            padding: 0px;
        }
        
        body, html {
            width: 100%;
            height: 100%;
            background-color: whitesmoke;
            font-family: sans-serif;
        }

        body {
            display: grid;
            grid-template-columns: 1fr 1fr;
        }

        h2 {
            margin-bottom: 16px;
        }
        
        button {
            display: block;
            margin: 16px 0px;
            padding: 8px;
        }

        #entryList {
            display: flex;
            row-gap: 16px;
            flex-direction: column;
            align-items: center;
            border-right: 1px solid black;
            overflow-y: auto;
            padding: 16px;
        }

        .entry {
            border: 1px solid gray;
            border-radius: 4px;
            padding: 8px;
            width: 100%;
            line-height: 24px;
        }

        #panel {
            display: flex;
            padding: 0px 24px;
            flex-direction: column;
            justify-content: space-around;
        }
    </style>
    <title>Blacklist interface</title>
    <script>
        <?php
        echo "const filePath = `$blacklist_filename`; const successMsg = '$success_message';";
        ?>
    </script>
</head>
<body>
    <div id="entryList">Retrieving data...</div>
    <div id="panel">
        <div>
            <h2>Filter entries</h2>
            <label>
                <input type="radio" name="filter" id="filterAll" checked> <span>Consider all entries in database.</span><br><br>
            </label>
            <label>
                <input type="radio" name="filter" id="filterDate"> <span>Consider only entries added on and after the following date:</span>
                <input type="date" id="filterDateCalendar"><br><br>
            </label>
            <label>
                <input type="radio" name="filter" id="filterDownload"> <span>Consider only entries that have not been downloaded.</span><br><br>
            </label>
        </div>

        <div>
            <h2>Download data</h2>
            Only entries that passed the filter will be included in the CSV file.
            <button id="downloadBtn">Download</button>
            <a id="downloader" hidden></a>
        </div>

        <div>
            <h2>Delete entries</h2>
            <button id="deleteDownloaded">Delete already downloaded entries</button>
            <button id="deleteDate">Delete entries added before the following date:</button>
            <input type="date" id="deleteCalendar">
        </div>
    </div>

    <script>
        const dataContainer = document.getElementById('entryList');

        const filterBtnAll = document.getElementById('filterAll');
        const filterBtnDate = document.getElementById('filterDate');
        const filterBtnDownload = document.getElementById('filterDownload');

        const filterDateCalendar = document.getElementById('filterDateCalendar');

        const downloadBtn = document.getElementById('downloadBtn');

        const deleteBtnDownloaded = document.getElementById('deleteDownloaded');
        const deleteBtnDate = document.getElementById('deleteDate');
        const deleteCalendar = document.getElementById('deleteCalendar');

        const downloader = document.getElementById('downloader');

        let realData = [];
        let data = [];

        async function getData() {
            // Updates realData
            try {
                let data = await fetch(filePath, {cache: "no-cache"});
                data = await data.json();
                realData = data;
                resetFilters();
                return true;
            } catch (e) {
                throw new Error('Couldn\'t get data from the database.');
            }
        }

        function displayData() {
            // Will display the contents of variable 'data', that's the filtered version of 'realData'
            if (data.length < 1) {
                dataContainer.innerHTML = "Nothing to show";
                return;
            }

            reversedData = Array.from(data).reverse();

            dataContainer.innerHTML = '';

            reversedData.forEach((e, i) => {
                let entry = document.createElement('div');
                let entryContent = '';

                for (const key in e) {
                    let label = key;
                    let value = e[key];

                    switch (key) {
                        case 'domain':
                            label = `<b>${label}`
                            value = `${value}</b>`;
                            break;
                        case 'time':
                            value = new Date(value*1000);
                            break;
                        case 'lastDownloadTime':
                            label = 'last downloaded on';
                            value = value == 0 ? 'never downloaded' : new Date(value*1000);
                            break;
                    }

                    entryContent += `${label}: ${value}<br>`;
                }

                entry.innerHTML = entryContent;
                entry.className = 'entry';

                dataContainer.append(entry);
            });
        }

        function filterData(filterType, options = {date: '', updateList: true, invert: false}) {
            // From variable 'realData', filter and store to variable 'data'
            // Returns the index of the entries that passed the filter (of variable 'realData'), or false in case of error
            
            if (options.date == undefined)
                options.date = '';
            if (options.updateList == undefined)
                options.updateList = true;
            if (options.invert == undefined)
                options.invert = false;

            let indexes = [];
            let newData = [];

            switch (filterType) {
                case 'all':
                    for (let i = 0; i < realData.length; i++)
                        indexes.push(i);
                    break;
                case 'date':
                    if (!options.date)
                        return false;

                    let unix = dateToUnix(options.date);

                    realData.forEach((e, i) => {
                        if (e.time >= unix)
                            indexes.push(i);
                    });
                    break;
                case 'downloaded':
                    realData.forEach((e, i) => {
                        if (e.lastDownloadTime > 0)
                            indexes.push(i);
                    });
                    break;
                default:
                    return false;
            }

            if (options.invert) {
                let newIndexes = [];
                for (let i = 0; i < realData.length; i++) {
                    if (!indexes.includes(i))
                        newIndexes.push(i);
                }
                indexes = newIndexes;
            }
            
            indexes.forEach(e => {
                newData.push(realData[e]);
            });


            if (options.updateList) {
                data = newData;
                displayData();
            }

            return indexes;
        }

        function downloadData() {
            // Will include the contents of variable 'data', that's the filtered version that is shown in the list at the interface
            let csv = '';
            let headers = [];

            for (const key in data[0]) {
                if (data[0].hasOwnProperty(key)) {
                headers.push(key);
                }
            }
            
            headers.forEach((e, i)=>{
                csv += e;
                if (i < headers.length-1)
                    csv += ',';
                else
                    csv += '\n';
            });

            data.forEach((entry, i) => {
                entry.lastDownloadTime = Math.round(new Date().getTime()/1000);

                headers.forEach((key, j) => {
                    switch(key) {
                        case 'time':
                            csv += new Date(entry[key]*1000);
                            break;
                        case 'lastDownloadTime':
                            csv += entry[key] == 0 ? 'never downloaded' : new Date(entry[key]*1000);
                            break;
                        default:
                            csv += entry[key];
                    }

                    if (j < headers.length-1)
                        csv += ',';
                    else
                        csv += '\n';
                });
            });

            const blob = new Blob([csv], { type: 'text/csv' });

            downloader.href = URL.createObjectURL(blob);
            downloader.download = 'blacklist.csv';
            downloader.click();
            updateDatabase();
        }

        function deleteEntries(indexList) {
            // Will fetch realData, delete the indexes from it and submit to server
            if (!indexList)
                return false;

            getData().then(r=>{
                let newData = [];
                let entryList = '';
                let deletedList = [];
                indexList.forEach(e => entryList = `${entryList}${realData[e].domain}, `);

                if (confirm(`You are about to delete the following ${indexList.length} entries:\n${entryList}`)) {
                    realData.forEach((e, i) => {
                        if (!indexList.includes(i))
                            newData.push(e);
                        else
                            deletedList.push(e.domain);
                    });

                    realData = newData;
                    updateDatabase(()=>{alert(`The following entries were successfully removed from the database:\n${String(deletedList)}`);});
                }
            }).catch(e => document.body.innerHTML = `<h1>An error ocurred<br>${e.message}</h1>`);
            
            return true;
        }

        function updateDatabase(callback = ()=>{}) {
            let xhttp = new XMLHttpRequest();
            let form = new FormData();

            form.append('operation', 'update');
            form.append('data', JSON.stringify(realData));

            xhttp.open('POST', location.href, false);

            xhttp.onreadystatechange = ()=>{
                try {
                    if (xhttp.readyState == 4) {
                        let r = xhttp.responseText;

                        if (r != successMsg)
                            throw new Error(`Response from server after trying to update database: ${r}`);

                        callback();
                        getData().catch(e => document.body.innerHTML = `<h1>An error ocurred<br>${e.message}</h1>`);
                    }
                }  catch (e) {
                    document.body.innerHTML = `<h1>An error ocurred<br>${e.message}</h1>`;   
                }
            }

            xhttp.send(form);

        }

        function resetFilters() {
            filterBtnAll.checked = true;
            data = realData;
            displayData();
        }

        function dateToUnix(date) {
            // From yyyy-mm-dd (system timezone) to unix (in seconds)
            const [year, month, day] = date.split("-");
            const dateObj = new Date(year, month - 1, day);
            const unixTimestamp = dateObj.getTime();
            const unixTimestampSeconds = unixTimestamp/1000;
            return unixTimestampSeconds;
        }

        filterBtnAll.addEventListener('click', ()=>{filterData('all')});
        filterBtnDate.addEventListener('click', ()=>{filterData('date', {date:filterDateCalendar.value})});
        filterDateCalendar.addEventListener('change', ()=>{ filterData('date', {date:filterDateCalendar.value}); filterBtnDate.checked = true; });
        filterBtnDownload.addEventListener('click', ()=>{filterData('downloaded', {invert: true})});
        downloadBtn.addEventListener('click', ()=>{downloadData()});
        deleteBtnDownloaded.addEventListener('click', ()=>{deleteEntries(filterData('downloaded', {updateList: false}))});
        deleteBtnDate.addEventListener('click', ()=>{deleteEntries(filterData('date', {date: deleteCalendar.value, invert: true, updateList: false}))});

        getData().catch(e => document.body.innerHTML = `<h1>An error ocurred<br>${e.message}</h1>`);

    </script>
</body>
</html>