<?php
    // Settings:
    $notification_email = "example@company.com";
    $timezone = "Australia/Sydney";
    $collect_IP_data = true;

    ///////////////////////////////////////////////////////////////////////////

    // A message given to the user
    $message_title="Successfully unsubscribed"; 
    $message_body="We apologize for any inconvenience. We will no longer contact you in the future.";
    $message_redirect_url=""; //if set, it will go to this URL after a short time

    date_default_timezone_set($timezone);
    $current_time = time();
    $current_date = date("l jS \of F Y h:i:s A", $current_time);

    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        $ip_address = $_SERVER['HTTP_CLIENT_IP'];
    }
    else if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip_address = $_SERVER['HTTP_X_FORWARDED_FOR'];
    }
    else {
        $ip_address = $_SERVER['REMOTE_ADDR'];
    }
    
    $default_value = "unknown";
    $user_city = $default_value;
    $user_country = $default_value;
    $user_continent = $default_value;
    $user_latitude = $default_value;
    $user_longitude = $default_value;
    
    if ($ip_address && $collect_IP_data) {
        try {
            $ip_data = json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip=$ip_address"));
            $user_city = $ip_data->geoplugin_city ? $ip_data->geoplugin_city : $default_value;
            $user_country = $ip_data->geoplugin_countryName ? $ip_data->geoplugin_countryName : $default_value;
            $user_continent = $ip_data->geoplugin_continentName ? $ip_data->geoplugin_continentName : $default_value;
            $user_latitude = $ip_data->geoplugin_latitude ? $ip_data->geoplugin_latitude : $default_value;
            $user_longitude = $ip_data->geoplugin_longitude ? $ip_data->geoplugin_longitude : $default_value;
        } catch (\Throwable $th) {
            $collect_IP_data = false;
        }
    }

    $url_parameter_for_domain="info"; 
    $blacklist_filename="blacklist.json";
    $empty_file_content = "[]";

    $style = "<style>\n*{margin:0;padding:0;box-sizing:border-box;--textcolor:#fff;--bgcolor:#121212;--highlight:#2749c9;}\n@media (prefers-color-scheme:dark){*{--textcolor:#141414;--bgcolor:#f0f0f0;--highlight:#ff7f00;}}\nbody{font-size:18px;font-family:system-ui,sans-serif;line-height:1.4;color:var(--textcolor);background:var(--bgcolor);position:relative;max-width:64em;margin:0 auto;}\nheader{padding:5vw 5vw 0 5vw; display:flex; flex-wrap:wrap; position:absolute; width:100%; z-index:2;}\n"."header h1{font-size:1em;flex:1;white-space:nowrap;padding:0 5vw .5em 0;}\np,ul,ol,article{max-width:60ch;margin-bottom:.6em;}\n</style>\n";
    $error_message = "<head><title>An error ocurred</title>$style</head><br><h1>An error ocurred while unsubscribing</h1><br><h3>We apologize for this, please contact support at $notification_email</h3><br><h3>Error message:</h3>";

    // Get domain and validate
    if (!array_key_exists($url_parameter_for_domain, $_GET))
        die($error_message . "No domain name provided.");
    $domain = $_GET[$url_parameter_for_domain];
    if ( !(($domain!="") && (preg_match('/^(?:[-A-Za-z0-9]+\.)+[A-Za-z]{2,6}$/',$domain))) )
        die($error_message . "Invalid domain name");

    set_error_handler(function ($severity, $message, $file, $line) {
        throw new \ErrorException($message, $severity, $severity, $file, $line);
    });
    
    // Add to blacklist and send notification to support email
    try {
        $email_subject = "Domain name $domain has unsubscribed";
        $email_message = "The domain name $domain has unsubscribed on $current_date ($timezone time). Data was recorded to the database successfully.";
        
        if (!file_exists($blacklist_filename)) {
            fwrite(fopen($blacklist_filename, "a"), $empty_file_content) or die($error_message . "Couldn't create database.");
        }
        
        $data_str = file_get_contents($blacklist_filename) or die($error_message . "Couldn't read database content.");
        
        if ($data_str == $empty_file_content) {
            $data = [];
        } else {
            $data = json_decode($data_str) or die($error_message . "Couldn't decode database content.");
        }
        
        array_push($data, ["domain"=>$domain, "time"=>$current_time, "country"=>$user_country, "city"=>$user_city, "continent"=>$user_continent, "latitude"=>$user_latitude, "longitude"=>$user_longitude, "lastDownloadTime"=>0]);

        $new_db_content = json_encode($data);
        (file_put_contents($blacklist_filename, $new_db_content) !== false) or die($error_message . "Couldn't write to database.");
        
        mail($notification_email, $email_subject, $email_message) or die($error_message . "Couldn't send notification message.");

    } catch (\Throwable $th) {
        die($error_message . $th->getMessage() . " on line " . $th->getLine());
    }


    // Output some message on the page
    echo "<html>\n".
         "  <head>\n".
         "    <title>".$message_title."</title>\n".
         '    <meta charset="utf-8">'."\n".
         '    <meta name="viewport" content="width=device-width,initial-scale=1">'."\n".$style;

    if($message_redirect_url!="") echo '    <meta http-equiv="refresh" content="5;url='.$message_redirect_url.'" />'."\n";
    
    echo "  </head>\n".
         "  <body>\n".
         "    <br><h1>".$message_title."</h1>\n".
         "    <br><p>".$message_body."</p>\n".
         "  </body>\n".
         "</html>";
?>